<?php
session_start();
include 'config.php';

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
} 

// Function to parse data from user_account.txt
function loadUserAccountData($filePath) {
    $data = [];
    if (file_exists($filePath)) {
        $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $headers = explode("\t", array_shift($lines)); // Read the first line as headers
        foreach ($lines as $line) {
            $row = array_combine($headers, explode("\t", $line));
            $data[] = $row;
        }
    }
    return $data;
}

// Load data from user_account.txt
$userAccounts = loadUserAccountData('user_accounts.txt');
?>

<!DOCTYPE html>
<html>
<head>
   <?php include 'style.php'; ?>
</head>
<body>

<?php include 'header.php'; ?>

<?php include 'manager_data.php'; ?>

<div class="topnav" style="background-color:transparent">
    <a href="manager.php" class="split"><i class="fa fa-users"></i> &nbsp;&nbsp;Manager</a>
    <a href="master.php" class="split"><i class="fa fa-line-chart"></i> &nbsp;&nbsp;Master</a>
    <a href="index.php" class="split" style="background-color:#ff6c2c;border-radius:20px"><i class="fa fa-user"></i> &nbsp;&nbsp;Profiles</a>
</div>

<div class="container">
    <div class="table-container">
        <h2 style="text-align:center; color: #fff;">Copy Trading</h2>
        <!-- Search Bar -->
        <div class="search-bar">
            <input type="text" id="search-input" placeholder="Search Copy Trading..." />
        </div>
        <!-- Table -->
        <div style="overflow-x:auto;">
            <table id="client-table">
                <thead>
                    <tr>
                        <th>SR No.</th>
                        <th>Trade ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Balance</th>
                        <th>Margin</th>
                        <th>Account</th>
                        <th>Leverage</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $srNo = 1; // Initialize serial number counter
                    foreach ($userAccounts as $account): ?>
                        <tr>
                            <td><?php echo $srNo++; ?></td> <!-- Display serial number -->
                            <td><?php echo htmlspecialchars($account['Login']); ?></td>
                            <td><?php echo htmlspecialchars($account['Name']); ?></td>
                            <td><?php echo htmlspecialchars($account['Email']); ?></td>
                            <td><?php echo htmlspecialchars($account['Balance']); ?></td>
                            <td><?php echo htmlspecialchars($account['Margin']); ?></td>
                            <td><?php echo htmlspecialchars($account['Group']); ?></td>
                            <td><?php echo htmlspecialchars($account['Leverage']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var input = this.value.toLowerCase();
        var rows = document.querySelectorAll('#client-table tbody tr');
        rows.forEach(function(row) {
            var rowText = row.textContent.toLowerCase();
            row.style.display = rowText.includes(input) ? '' : 'none';
        });
    });
</script>

</body>
</html>
