<?php
// Simplified registration script that only sends verification email

// Include test configuration
require_once 'test_mail_config.php';

// Include only the mail system
require_once 'mail_system/integrated_mail_system.php';

// Test user data
$first_name = 'Sagar';
$last_name = 'Nandal';
$email = 'sagarnandal95@gmail.com';
$password = 'TestPassword123!';

echo "🚀 Registering user: $first_name $last_name ($email)\n";
echo "==========================================\n";

// Generate verification token
$emailToken = bin2hex(random_bytes(16));

echo "Generated User Details:\n";
echo "  First Name: $first_name\n";
echo "  Last Name: $last_name\n";
echo "  Email: $email\n";
echo "  Email Token: $emailToken\n\n";

// Send registration verification email
echo "📧 Sending registration verification email...\n";

$mailSystem = getMailSystem();
$fullName = $first_name . ' ' . $last_name;

$emailResult = $mailSystem->sendRegisterVerification($email, $fullName, $emailToken);

if ($emailResult['success']) {
    echo "✅ Registration verification email sent successfully!\n";
    echo "   Message: " . $emailResult['message'] . "\n";
} else {
    echo "❌ Failed to send registration verification email.\n";
    echo "   Error: " . $emailResult['message'] . "\n";
}

echo "\n🎉 Registration process completed!\n";
echo "Please check your email inbox at $email for the verification email.\n";
echo "Verification link: https://ecotradefx.com/verify?code=$emailToken\n";
?>