<?php
/**
 * Simple Email Test Script
 * Tests email functionality without database dependencies
 */

// Test data for sagarnandal95@gmail.com
$test_email = 'sagarnandal95@gmail.com';
$test_name = 'Sagar Nandal';

echo "=== Simple Email Sending Test ===\n\n";

// Define all required configuration constants first
if (!defined('EMAIL_AUTOMATION_ENABLED')) {
    define('EMAIL_AUTOMATION_ENABLED', true);
}
if (!defined('MAIL_HOST')) {
    define('MAIL_HOST', 'send.smtp.com');
}
if (!defined('MAIL_PORT')) {
    define('MAIL_PORT', 465);
}
if (!defined('MAIL_USERNAME')) {
    define('MAIL_USERNAME', 'support@mykfmarkets.com');
}
if (!defined('MAIL_PASSWORD')) {
    define('MAIL_PASSWORD', 'support@mykfmarkets.com');
}
if (!defined('MAIL_ENCRYPTION')) {
    define('MAIL_ENCRYPTION', 'PHPMailer::ENCRYPTION_SMTPS');
}
if (!defined('MAIL_FROM_EMAIL')) {
    define('MAIL_FROM_EMAIL', 'support@mykfmarkets.com');
}
if (!defined('MAIL_FROM_NAME')) {
    define('MAIL_FROM_NAME', 'MyKF Markets');
}
if (!defined('APP_URL')) {
    define('APP_URL', 'https://mykfmarkets.com');
}
if (!defined('DEPOSIT_PROCESSING_TIME')) {
    define('DEPOSIT_PROCESSING_TIME', '1-24 hours');
}
if (!defined('WITHDRAWAL_PROCESSING_TIME')) {
    define('WITHDRAWAL_PROCESSING_TIME', '1-3 business days');
}
if (!defined('IB_COMMISSION_RATE')) {
    define('IB_COMMISSION_RATE', '1.5%');
}
if (!defined('LOG_PATH')) {
    define('LOG_PATH', __DIR__ . '/logs/');
}
if (!defined('MAIL_LOGO_URL')) {
    define('MAIL_LOGO_URL', 'https://mykfmarkets.com/assets/images/logo.png');
}
if (!defined('MAIL_COMPANY_NAME')) {
    define('MAIL_COMPANY_NAME', 'MyKF Markets');
}
if (!defined('MAIL_COMPANY_ADDRESS')) {
    define('MAIL_COMPANY_ADDRESS', '123 Trading Street, Financial District');
}
if (!defined('MAIL_SUPPORT_EMAIL')) {
    define('MAIL_SUPPORT_EMAIL', 'support@mykfmarkets.com');
}
if (!defined('MAIL_WEBSITE_URL')) {
    define('MAIL_WEBSITE_URL', 'https://mykfmarkets.com');
}
if (!defined('EMAIL_LOG_ENABLED')) {
    define('EMAIL_LOG_ENABLED', true);
}

echo "✅ All configuration constants defined\n";

// Include the mail system
$mailSystemFile = __DIR__ . '/mail_system/integrated_mail_system.php';
if (file_exists($mailSystemFile)) {
    include_once $mailSystemFile;
    echo "✅ Mail system file loaded\n";
} else {
    echo "❌ Mail system file not found at: $mailSystemFile\n";
    exit(1);
}

// Test 1: Check if mail system is available
echo "1. Testing Mail System Availability...\n";
if (class_exists('IntegratedMailSystem')) {
    echo "   ✅ IntegratedMailSystem class is available\n";
} else {
    echo "   ❌ IntegratedMailSystem class is NOT available\n";
    exit(1);
}

// Test 2: Initialize mail system
echo "2. Initializing Mail System...\n";
try {
    $mailSystem = new IntegratedMailSystem();
    echo "   ✅ Mail system initialized successfully\n";
} catch (Exception $e) {
    echo "   ❌ Failed to initialize mail system: " . $e->getMessage() . "\n";
    exit(1);
}

// Test 3: Test sending a simple email using one of the templates
echo "3. Testing Email Sending...\n";
try {
    // Using the deposit_request_submitted template as an example
    $result = $mailSystem->sendDepositRequestSubmitted(
        $test_email,
        $test_name,
        1000.00,     // amount
        'USD',       // currency
        'Bank Transfer', // payment method
        'DEP-TEST-001'   // transaction reference
    );
    
    if ($result['success']) {
        echo "   ✅ Email sent successfully to $test_email\n";
        echo "   Message: " . $result['message'] . "\n";
    } else {
        echo "   ❌ Failed to send email: " . $result['message'] . "\n";
    }
} catch (Exception $e) {
    echo "   ❌ Exception occurred while sending email: " . $e->getMessage() . "\n";
}

// Test 4: Try sending another email template
echo "\n4. Testing Another Email Template...\n";
try {
    $result = $mailSystem->sendRegisterVerification(
        $test_email,
        $test_name,
        'VERIFY-TEST-123',
        '24 hours'
    );
    
    if ($result['success']) {
        echo "   ✅ Registration verification email sent successfully\n";
    } else {
        echo "   ⚠️  Registration verification email failed: " . $result['message'] . "\n";
    }
} catch (Exception $e) {
    echo "   ❌ Exception in registration verification: " . $e->getMessage() . "\n";
}

echo "\n=== Test Complete ===\n";
echo "If emails were sent successfully, please check $test_email for the test messages.\n";
echo "If you don't receive the emails, check your spam/junk folder.\n";
?>