<?php
require_once 'config.php';
require_once 'mail_system.php';

echo "<h2>Testing EcoTradeFX Branding Update</h2>\n";

// Display current configuration
echo "<h3>Current Configuration:</h3>\n";
echo "Brand Name: " . BRAND_NAME . "<br>\n";
echo "Mail From Name: " . MAIL_FROM_NAME . "<br>\n";
echo "Mail From Email: " . MAIL_FROM_EMAIL . "<br>\n";
echo "Logo URL: https://ecotradefx.com/lib/logo.png<br>\n";

// Check if online logo URL is accessible
$logo_url = 'https://ecotradefx.com/lib/logo.png';
$headers = @get_headers($logo_url);
if ($headers && strpos($headers[0], '200') !== false) {
    echo "✅ Online logo URL is accessible: " . $logo_url . "<br>\n";
    echo "✅ Logo will be loaded directly from EcoTradeFX website<br>\n";
} else {
    echo "⚠️ Could not verify logo URL accessibility (may be due to network/firewall): " . $logo_url . "<br>\n";
    echo "ℹ️ Logo will still be used in emails (email clients handle external images)<br>\n";
}

echo "<hr>\n";

// Test sending email with new branding
echo "<h3>Sending Test Email with EcoTradeFX Branding:</h3>\n";

try {
    $mailSystem = new ZForexMailer();
    
    // Test data for registration verification email
    $test_data = [
        'user_name' => 'Test User',
        'verification_link' => 'https://example.com/verify?token=test123',
        'brand_name' => BRAND_NAME
    ];
    
    $result = $mailSystem->sendMail(
        'sagarnandal95@gmail.com',
        'Test User',
        'register_verification',
        $test_data
    );
    
    if ($result['success']) {
        echo "✅ <strong>SUCCESS!</strong> Test email sent successfully to mkroy101112@gmail.com<br>\n";
        echo "📧 Email includes:<br>\n";
        echo "- EcoTradeFX logo from https://ecotradefx.com/lib/logo.png<br>\n";
        echo "- Updated brand name: " . BRAND_NAME . "<br>\n";
        echo "- Professional email template design<br>\n";
        echo "- Sent from: " . MAIL_FROM_EMAIL . "<br>\n";
    } else {
        echo "❌ <strong>FAILED!</strong> " . $result['message'] . "<br>\n";
    }
    
} catch (Exception $e) {
    echo "❌ <strong>ERROR!</strong> " . $e->getMessage() . "<br>\n";
}

echo "<hr>\n";
echo "<h3>Branding Update Summary:</h3>\n";
echo "✅ Brand name updated to: <strong>EcoTradeFX</strong><br>\n";
echo "✅ Logo integrated from: <strong>https://ecotradefx.com/lib/logo.png</strong><br>\n";
echo "✅ Email templates now include company logo from online URL<br>\n";
echo "✅ All email communications branded as EcoTradeFX<br>\n";

echo "<p><em>Check your email at mkroy101112@gmail.com to see the new EcoTradeFX branding!</em></p>\n";
?>