<?php
/**
 * Simple Mail Example
 * This shows the easiest way to call the mail system from any file
 */

// Step 1: Include the mail system
require_once 'mail_system.php';

// Step 2: Create your function
function sendWelcomeEmail($userEmail, $userName) {
    // Call the global mail function
    $result = sendZForexMail(
        $userEmail,           // User's email
        $userName,            // User's name
        'register_verification',  // Template name
        [                     // Variables for the template
            'verification_url' => 'https://yoursite.com/verify?token=abc123'
        ]
    );
    
    // Check if email was sent successfully
    if ($result['success']) {
        return "Email sent successfully!";
    } else {
        return "Failed to send email: " . $result['message'];
    }
}

// Step 3: Use your function anywhere
function registerNewUser($email, $name, $password) {
    // Your registration logic here...
    // Insert user to database, etc.
    
    // Then send welcome email
    $emailResult = sendWelcomeEmail($email, $name);
    
    return $emailResult;
}

// Example usage:
if ($_POST['action'] == 'register') {
    $result = registerNewUser($_POST['email'], $_POST['name'], $_POST['password']);
    echo $result;
}

// Or call directly:
// $result = sendWelcomeEmail('user@example.com', 'John Doe');
// echo $result;

?>

<!-- 
QUICK REFERENCE - How to call mail from any file:

1. Include the mail system:
   require_once 'mail_system.php';

2. Call the global function:
   $result = sendZForexMail($email, $name, $template, $variables);

3. Available templates:
   - 'register_verification'
   - 'after_verify_credentials'
   - 'login_alert'
   - 'open_live_account'
   - 'kyc_upload'
   - 'kyc_approved'
   - 'deposit_request_submitted'
   - 'deposit_approved'
   - 'otp_withdrawal'
   - 'withdrawal_request_submitted'
   - 'withdrawal_approved'
   - 'ib_commission_withdrawal'
   - 'referral_registration'
   - 'trade_open'
   - 'trade_close'
   - 'daily_trade_summary'
   - 'password_reset'
   - 'password_changed'
   - 'profile_updated'
   - 'deposit_failed'
   - 'withdrawal_rejected'
   - 'monthly_statement'

4. Example calls:

   // Registration verification
   sendZForexMail('user@email.com', 'John Doe', 'register_verification', [
       'verification_url' => 'https://site.com/verify?token=abc123'
   ]);

   // Login alert
   sendZForexMail('user@email.com', 'John Doe', 'login_alert', [
       'login_time' => date('Y-m-d H:i:s'),
       'ip_address' => $_SERVER['REMOTE_ADDR'],
       'device_info' => 'Chrome on Windows'
   ]);

   // Deposit approved
   sendZForexMail('user@email.com', 'John Doe', 'deposit_approved', [
       'amount' => '1000',
       'currency' => 'USD',
       'new_balance' => '5000',
       'transaction_id' => 'TXN123456'
   ]);

   // Trade opened
   sendZForexMail('user@email.com', 'John Doe', 'trade_open', [
       'trade_symbol' => 'EURUSD',
       'trade_side' => 'BUY',
       'trade_volume' => '0.1',
       'price' => '1.0850',
       'order_id' => 'ORD123456'
   ]);  mkroy101112@gmail.com 

-->