<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include 'config.php';  // Database connection

// Fetch all users from loginusers table (including created_at & reg_date)
$sql = "SELECT id, first_name, last_name, email, phone, country, password, 
               kyc_status, email_confirmed, created_at, reg_date 
        FROM loginusers 
        ORDER BY id DESC";

$result = $conn->query($sql);

$clients = [];

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $clients[] = [
            "id" => $row['id'],
            "trade_id" => "N/A", // Not in loginusers
            "account_name" => $row['first_name'] . ' ' . $row['last_name'],
            "email" => $row['email'],
            "phone_pwd" => $row['phone'],
            "strategycountry" => $row['country'],
            "status" => "Enabled", // Static
            "email_kyc" => $row['email_confirmed'],
            "password" => $row['password'],
            "kyc_status" => $row['kyc_status'],
            "created_at" => $row['created_at'],
            "reg_date" => $row['reg_date']
        ];
    }
}

// Send response
echo json_encode([
    "success" => true,
    "clients" => $clients
]);
?>
