<?php
// fetch_accounttypes.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . "/config.php";

try {
    // Create PDO connection
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $dbh = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);

    // Fetch account types including new columns ac_swap and ac_commission
    $stmt = $dbh->query("SELECT 
            ac_index,
            ac_name,
            ac_group,
            ac_min_deposit,
            ac_max_deposit,
            ac_max_leverage,
            ac_spread,
            ac_swap,
            ac_commission,
            ib_commission1,
            ib_commission2,
            ib_commission3,
            ib_commission4,
            ib_commission5,
            ib_commission6,
            ib_commission7,
            ib_commission8,
            ib_commission9,
            ib_commission10
        FROM account_types
        ORDER BY ac_index ASC");

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "success" => true,
        "count"   => count($rows),
        "data"    => $rows
    ]);
} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "error"   => "Database query failed",
        "details" => $e->getMessage()
    ]);
    exit;
}
