<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Enable PHP error reporting for debugging (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "config.php"; // DB connection
include "connection.php"; // MT5 connection

$data = json_decode(file_get_contents("php://input"), true);
$user_id = $data['user_id'] ?? 0;

if (!$user_id) {
    echo json_encode(["success" => false, "message" => "Missing user id"]);
    exit;
}

// Initialize MT5 connection
$mt5 = new MT5Connection(); 
if (!$mt5->connect()) {
    echo json_encode([
        "success" => false,
        "message" => "MT5 connection failed, error code: " . $mt5->lastError()
    ]);
    exit;
}

$api = $mt5->api; // $api is ready to use

//unused_commission
// ===============================
// AUTO-GENERATE UNUSED DEPOSIT COMMISSION (runs on dashboard load)
// ===============================

// try {
//     // fetch settings
//     $stmtSetting = $conn->prepare("SELECT days_threshold, commission_percent FROM deposit_unused_commission_settings LIMIT 1");
//     $stmtSetting->execute();
//     $resSetting = $stmtSetting->get_result();
//     $settingRow = $resSetting->fetch_assoc() ?: ["days_threshold" => 45, "commission_percent" => 1.00];
//     $stmtSetting->close();

//     $daysThreshold = (int)$settingRow['days_threshold'];
//     $commissionPercent = (float)$settingRow['commission_percent'];

//     // select eligible deposits for this user that are approved and older than threshold
// //     $query = "
// //   SELECT wd.id AS deposit_id, wd.trade_id, wd.deposit_amount, wd.deposed_date, la.user_id, lu.email AS ib_email
// //   FROM wallet_deposit wd
// //   JOIN liveaccounts la ON la.trade_id = wd.trade_id
// //   JOIN loginusers lu ON lu.id = la.user_id
// //   WHERE la.user_id = ?
// //     AND wd.Status = 1
// //     AND wd.deposed_date <= DATE_SUB(NOW(), INTERVAL ? DAY)
// //     AND wd.id NOT IN (
// //         SELECT deposit_id FROM unused_deposit_commission_log
// //         WHERE status = 'credited'
// //     )
// //   ORDER BY wd.deposed_date ASC
// // ";

// //new to check the withdrawal
// $query = "
//   SELECT 
//       wd.id AS deposit_id, 
//       wd.trade_id, 
//       wd.deposit_amount, 
//       wd.deposed_date, 
//       la.user_id, 
//       lu.email AS ib_email
//   FROM wallet_deposit wd
//   JOIN liveaccounts la ON la.trade_id = wd.trade_id
//   JOIN loginusers lu ON lu.id = la.user_id
//   WHERE la.user_id = ?
//     AND wd.Status = 1
//     AND wd.deposed_date <= DATE_SUB(NOW(), INTERVAL ? DAY)
//     AND wd.id NOT IN (
//         SELECT deposit_id FROM unused_deposit_commission_log
//         WHERE status = 'credited'
//     )
//     AND NOT EXISTS (
//         SELECT 1 FROM wallet_withdraw ww
//         WHERE ww.trade_id = wd.trade_id
//     )
//   ORDER BY wd.deposed_date ASC
// ";


//     $stmt = $conn->prepare($query);
//     $stmt->bind_param("ii", $user_id, $daysThreshold);
//     $stmt->execute();
//     $res = $stmt->get_result();

//     // prepare insert for log table
//     $insertStmt = $conn->prepare("
//         INSERT INTO unused_deposit_commission_log
//         (user_id, trade_id, deposit_id, deposit_amount, commission_percent, commission_amount, days_threshold, status)
//         VALUES (?, ?, ?, ?, ?, ?, ?, 'credited')
//         ON DUPLICATE KEY UPDATE id=id
//     ");

//     // prepare update/insert for ib_total_profit_commission
//     $updateIBStmt = $conn->prepare("
//         INSERT INTO ib_total_profit_commission (ib_email, total_profit_commission, available_profit_commission)
//         VALUES (?, ?, ?)
//         ON DUPLICATE KEY UPDATE 
//           total_profit_commission = total_profit_commission + VALUES(total_profit_commission),
//           available_profit_commission = available_profit_commission + VALUES(available_profit_commission)
//     ");

//     while ($row = $res->fetch_assoc()) {
//         $depositId = (int)$row['deposit_id'];
//         $tradeId = $row['trade_id'];
//         $depositAmount = (float)$row['deposit_amount'];
//         $ibEmail = $row['ib_email'];

//         // calculate commission
//         $commissionAmount = round(($depositAmount * $commissionPercent) / 100, 4);

//         // insert into log
//         $insertStmt->bind_param(
//             "issdddi",
//             $row['user_id'],
//             $tradeId,
//             $depositId,
//             $depositAmount,
//             $commissionPercent,
//             $commissionAmount,
//             $daysThreshold
//         );
//         $insertStmt->execute();

//         // update ib_total_profit_commission
//         $updateIBStmt->bind_param("sdd", $ibEmail, $commissionAmount, $commissionAmount);
//         $updateIBStmt->execute();
//     }

//     $insertStmt->close();
//     $updateIBStmt->close();
//     $stmt->close();

// } catch (Throwable $e) {
//     error_log("Unused deposit commission check failed: " . $e->getMessage());
// }



// 1️⃣ Get total approved deposits and withdrawals from wallet tables
$stmt = $conn->prepare("
    SELECT 
        (SELECT COALESCE(SUM(CAST(deposit_amount AS DECIMAL(18,2))),0) 
         FROM wallet_deposit 
         WHERE trade_id IN (SELECT trade_id FROM liveaccounts WHERE user_id = ?)
           AND Status = 1) AS total_deposit,
        (SELECT COALESCE(SUM(CAST(withdraw_amount AS DECIMAL(18,2))),0) 
         FROM wallet_withdraw 
         WHERE trade_id IN (SELECT trade_id FROM liveaccounts WHERE user_id = ?)
           AND Status = 1) AS total_withdraw
");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$totalsDB = $stmt->get_result()->fetch_assoc();
// NEW: Cent-only deposits & withdrawals
$stmtCent = $conn->prepare("
    SELECT 
        (SELECT COALESCE(SUM(CAST(deposit_amount AS DECIMAL(18,2))),0)
         FROM wallet_deposit
         WHERE trade_id IN (SELECT trade_id FROM liveaccounts WHERE user_id = ? AND account_type LIKE '%Cent%')
           AND Status = 1) AS cent_deposit,

        (SELECT COALESCE(SUM(CAST(withdraw_amount AS DECIMAL(18,2))),0)
         FROM wallet_withdraw
         WHERE trade_id IN (SELECT trade_id FROM liveaccounts WHERE user_id = ? AND account_type LIKE '%Cent%')
           AND Status = 1) AS cent_withdraw
");
$stmtCent->bind_param("ii", $user_id, $user_id);
$stmtCent->execute();
$centTotals = $stmtCent->get_result()->fetch_assoc();


// 2️⃣ Get active MT5 accounts including account_type
$stmt2 = $conn->prepare("SELECT trade_id, account_name, leverage, Balance, account_type FROM liveaccounts WHERE user_id = ?");
$stmt2->bind_param("i", $user_id);
$stmt2->execute();
$result2 = $stmt2->get_result();

$activeAccounts = [];
$total_balance = 0;
$total_profit_all = 0;
// NEW: Cent + Normal totals
$cent_balance = 0;
$cent_profit = 0;
$cent_equity = 0;

$normal_balance = 0;
$normal_profit = 0;
$normal_equity = 0;

while ($row = $result2->fetch_assoc()) {
    $trade_id = $row['trade_id'];
    $account_name = $row['account_name'];
    $leverage = $row['leverage'];
    $account_type = $row['account_type'];
    $balance_db = is_numeric($row['Balance']) ? (float)$row['Balance'] : 0;

    $balance = $balance_db;
    $floating_profit = 0;
    $equity = $balance_db;

    // Fetch live data from MT5 safely
    try {
        if (($error_code = $api->UserAccountGet($trade_id, $account)) == MTRetCode::MT_RET_OK && isset($account->Balance)) {
            $balance = (float)$account->Balance;
            $floating_profit = (float)($account->Floating ?? 0);
            $equity = $balance + $floating_profit;
            // -------- NEW: detect Cent accounts --------
if (stripos($account_type, "Cent") !== false) {

    // CENT ACCOUNTS TOTAL
    $cent_balance += $balance;
    $cent_profit += $floating_profit;
    $cent_equity += $equity;

} else {

    // NORMAL ACCOUNTS TOTAL
    $normal_balance += $balance;
    $normal_profit += $floating_profit;
    $normal_equity += $equity;
}

        }
    } catch (Exception $e) {
        $balance = $balance_db;
        $floating_profit = 0;
        $equity = $balance;
    }

    $activeAccounts[] = [
        "trade_id" => $trade_id,
        "account_name" => $account_name,
        "account_type" => $account_type,
        "Balance" => $balance,
        "leverage" => $leverage,
        "total_profit" => $floating_profit,
        "equity" => $equity
    ];

    $total_balance += $equity;
    $total_profit_all += $floating_profit; // <-- sum profit
}

// 3️⃣ Totals including total profit
$totals = [
    "total_balance" => $total_balance,
    "total_deposit" => (float)$totalsDB['total_deposit'],
    "total_withdraw" => (float)$totalsDB['total_withdraw'],
    "total_profit" => $total_profit_all,

    // NEW: CENT TOTALS
    "cent_balance" => $cent_balance,
    "cent_equity" => $cent_equity,
    "cent_profit" => $cent_profit,
    "cent_deposit" => (float)$centTotals['cent_deposit'],
    "cent_withdraw" => (float)$centTotals['cent_withdraw'],

    // NEW: NORMAL TOTALS
    "normal_balance" => $normal_balance,
    "normal_equity" => $normal_equity,
    "normal_profit" => $normal_profit,

    "mt5_accounts" => count($activeAccounts)
];


// 4️⃣ Get recent transactions (only approved deposits and withdrawals)
$stmt3 = $conn->prepare("
    SELECT id, 'Deposit' AS type, deposit_amount AS amount, deposed_date AS date
    FROM wallet_deposit
    WHERE trade_id IN (SELECT trade_id FROM liveaccounts WHERE user_id = ?)
      AND Status = 1
    UNION ALL
    SELECT id, 'Withdrawal' AS type, withdraw_amount AS amount, withdraw_date AS date
    FROM wallet_withdraw
    WHERE trade_id IN (SELECT trade_id FROM liveaccounts WHERE user_id = ?)
      AND Status = 1
    ORDER BY date DESC
    LIMIT 5
");
$stmt3->bind_param("ii", $user_id, $user_id);
$stmt3->execute();
$result3 = $stmt3->get_result();

$recentTransactions = [];
while($row = $result3->fetch_assoc()){
    $recentTransactions[] = [
        "id" => $row['id'],
        "type" => $row['type'],
        "amount" => is_numeric($row['amount']) ? (float)$row['amount'] : 0,
        "date" => $row['date'],
        "status" => "Completed"
    ];
}

// 5️⃣ Return final JSON
echo json_encode([
    "success" => true,
    "totals" => $totals,
    "activeAccounts" => $activeAccounts,
    "recentTransactions" => $recentTransactions
]);
?>
