<?php
/**
 * ZForex Trading Platform - Main Configuration File
 * Includes database connection, mail system, and all application settings
 */

// ================================
// DATABASE CONFIGURATION
// ================================
define("DB_HOST", "localhost");
define("DB_USER", "root");
define("DB_PASS", "");
define("DB_NAME", "crmcentrioglobal_qfx-markets");

// Create mysqli connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("❌ Database connection failed: " . $conn->connect_error);
}

// ================================
// MAIL SYSTEM CONFIGURATION
// ================================


define("MAIL_HOST", "smtp.hostinger.com");                    // Hostinger SMTP host
define("MAIL_PORT", 465);                                     // 465 for SSL
define("MAIL_USERNAME", "support@ernfxmarkets.com");          // New email
define("MAIL_PASSWORD", "Creative@3298");                    // New password
define("MAIL_ENCRYPTION", "ssl");                             // ssl for port 465
define("MAIL_FROM_EMAIL", "support@ernfxmarkets.com");        // From email address
define("MAIL_FROM_NAME", "ERNFXMarkets");                     // From name

// ================================
// BRANDING & URLs
// ================================
define("BRAND_NAME", "ERNFXMarkets");                         // Brand name
define('COMPANY_NAME', 'ERNFXMarkets');
define('COMPANY_WEBSITE', 'https://ernfxmarkets.com');
define('SUPPORT_EMAIL', 'support@ernfxmarkets.com');
define('COMPANY_ADDRESS', 'Your Company Address');

// ================================
// APPLICATION SETTINGS
// ================================
define('APP_NAME', 'ERNFXMarkets');
define('APP_URL', 'https://user.ernfxmarkets.com');           // Updated client URL
define('APP_ENVIRONMENT', 'production');     
define('LOG_PATH', __DIR__ . '/logs/');// or keep 'development' if needed
// ================================
// MT5 API CONFIGURATION
// ================================


// ================================
// MAIL SYSTEM INTEGRATION
// ================================
// Include the integrated mail system
if (file_exists(__DIR__ . '/mail_system/integrated_mail_system.php')) {
    require_once __DIR__ . '/mail_system/integrated_mail_system.php';
    
    // Initialize mail system for global use
    $mailSystem = getMailSystem();
    
    // Make mail functions globally available
    if (!function_exists('sendWelcomeEmail')) {
        function sendWelcomeEmail($to, $name, $loginUrl = '') {
            global $mailSystem;
            return $mailSystem->sendWelcomeEmail($to, $name, $loginUrl);
        }
    }
    
    if (!function_exists('sendPasswordResetEmail')) {
        function sendPasswordResetEmail($to, $name, $resetLink) {
            global $mailSystem;
            return $mailSystem->sendPasswordResetEmail($to, $name, $resetLink);
        }
    }
    
    if (!function_exists('sendDepositConfirmationEmail')) {
        function sendDepositConfirmationEmail($to, $name, $amount, $method, $transactionId) {
            global $mailSystem;
            return $mailSystem->sendDepositConfirmationEmail($to, $name, $amount, $method, $transactionId);
        }
    }
    
    if (!function_exists('sendWithdrawalConfirmationEmail')) {
        function sendWithdrawalConfirmationEmail($to, $name, $amount, $method, $transactionId) {
            global $mailSystem;
            return $mailSystem->sendWithdrawalConfirmationEmail($to, $name, $amount, $method, $transactionId);
        }
    }
    
    if (!function_exists('sendKYCApprovalEmail')) {
        function sendKYCApprovalEmail($to, $name) {
            global $mailSystem;
            return $mailSystem->sendKYCApprovalEmail($to, $name);
        }
    }
    
    if (!function_exists('sendKYCRejectionEmail')) {
        function sendKYCRejectionEmail($to, $name, $reason) {
            global $mailSystem;
            return $mailSystem->sendKYCRejectionEmail($to, $name, $reason);
        }
    }
    
    if (!function_exists('sendAccountVerificationEmail')) {
        function sendAccountVerificationEmail($to, $name, $verificationLink) {
            global $mailSystem;
            return $mailSystem->sendAccountVerificationEmail($to, $name, $verificationLink);
        }
    }
    
    if (!function_exists('sendTradingAccountCreatedEmail')) {
        function sendTradingAccountCreatedEmail($to, $name, $accountNumber, $accountType, $leverage) {
            global $mailSystem;
            return $mailSystem->sendTradingAccountCreatedEmail($to, $name, $accountNumber, $accountType, $leverage);
        }
    }
    
} else {
    // Mail system not available - log warning
    error_log("⚠️ Mail system not found at: " . __DIR__ . '/mail_system/integrated_mail_system.php');
}

// ================================
// CORS HEADERS
// ================================
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

?>