<?php
// Syntax check for register.php
echo "Checking syntax for register.php...\n";

// Check if the file exists
if (!file_exists('register.php')) {
    echo "❌ register.php file not found\n";
    exit(1);
}

// Try to include the file to check for syntax errors
try {
    include 'register.php';
    echo "✅ No syntax errors found\n";
} catch (ParseError $e) {
    echo "❌ Syntax error in register.php: " . $e->getMessage() . "\n";
    exit(1);
} catch (Exception $e) {
    echo "⚠️  Other error (not syntax): " . $e->getMessage() . "\n";
}
?>