<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

include_once __DIR__ . '/config.php';

$response = ["success" => false, "message" => "No data found", "data" => []];

// Check if 'id' is provided via GET
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $userId = intval($_GET['id']);

    $stmt = $conn->prepare("SELECT * FROM loginusers WHERE id = ?");
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $response['success'] = true;
        $response['message'] = "User found";
        $response['data'] = $result->fetch_assoc();
    } else {
        $response['message'] = "User not found";
    }
    $stmt->close();
} else {
    $response['message'] = "User ID is required";
}

$conn->close();
echo json_encode($response);
?>
