<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

ini_set('display_errors', 0);
ini_set('log_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . "/config.php";

try {

    // Fetch all permissions
    $sql = "SELECT id, name, module, description FROM permissions ORDER BY module ASC, name ASC";
    $result = $conn->query($sql);

    $permissions = [];

    while ($row = $result->fetch_assoc()) {
        $permissions[] = [
            "id" => intval($row["id"]),
            "name" => $row["name"],
            "module" => $row["module"],
            "description" => $row["description"]
        ];
    }

    echo json_encode([
        "success" => true,
        "permissions" => $permissions
    ]);

} catch (Exception $e) {

    echo json_encode([
        "success" => false,
        "message" => "Server Error",
        "error" => $e->getMessage()
    ]);
}

?>
