<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include('config.php');

// ✅ Set timezone (change as per your region if needed)
date_default_timezone_set('Asia/Kolkata'); // For India time

// ✅ Get start (today 12:00 AM) and end (current time)
$today_start = date('Y-m-d 00:00:00');
$now = date('Y-m-d H:i:s');

// Initialize totals
$total_deposits = 0.00;
$total_withdrawals = 0.00;

// ------------------- DEPOSITS (Today's approved) -------------------
$walletDepositSql = "SELECT SUM(deposit_amount) AS total FROM wallet_deposit 
                     WHERE Status = 1 
                     AND deposed_date BETWEEN '$today_start' AND '$now'";
$walletDepositResult = $conn->query($walletDepositSql);
if ($row = $walletDepositResult->fetch_assoc()) {
    $total_deposits = floatval($row['total']);
}

// ------------------- WITHDRAWALS (Today's approved) -------------------
$walletWithdrawSql = "SELECT SUM(withdraw_amount) AS total FROM wallet_withdraw 
                      WHERE Status = 1 
                      AND withdraw_date BETWEEN '$today_start' AND '$now'";
$walletWithdrawResult = $conn->query($walletWithdrawSql);
if ($row = $walletWithdrawResult->fetch_assoc()) {
    $total_withdrawals = floatval($row['total']);
}

// ------------------- NET DEPOSIT -------------------
$net_deposit = $total_deposits - $total_withdrawals;

// ------------------- RESPONSE -------------------
$response = [
    'success' => true,
    'period' => [
        'from' => $today_start,
        'to' => $now
    ],
    'totals' => [
        'total_deposits' => round($total_deposits, 2),
        'total_withdrawals' => round($total_withdrawals, 2),
        'net_deposit' => round($net_deposit, 2)
    ]
];

echo json_encode($response, JSON_PRETTY_PRINT);
?>
